/* this file is the configuration and implementation of the ctx 
 * library, with adaptations to permit multipass SIMD builds.
 */

#include <stdint.h>
#include <stdlib.h>
#include <termios.h>
#include <unistd.h>

#if CTX_BABL
#include <babl/babl.h>
#endif

#define CTX_WANT_FONT 1
#include "ctx_config.h"

#include "stb_image.h"

#ifdef CTX_SIMD_X86_64_V2
#define CTX_SIMD_SUFFIX(symbol)  symbol##_x86_64_v2
#endif
#ifdef CTX_SIMD_X86_64_V3
#define CTX_SIMD_SUFFIX(symbol)  symbol##_x86_64_v3
#endif
#ifdef CTX_SIMD_ARM_NEON
#define CTX_SIMD_SUFFIX(symbol)  symbol##_arm_neon
#endif

#ifndef CTX_SIMD_SUFFIX

#define CTX_IMPLEMENTATION 1
#if CTX_SDL
#include <SDL.h>
#endif

#if CTX_STB_IMAGE
#define STB_IMAGE_IMPLEMENTATION
#include "stb_image.h"
#endif

#define CSS_HAVE_FS 0


#include "ctx.h"


#if CTX_BABL
#include <babl/babl.h>
#else
#undef CTX_ENABLE_CM
#define CTX_ENABLE_CM  0
#endif


#if defined(CTX_SIMD_X86_64_V2)
#define CTX_SIMD_SUFFIX(symbol)  symbol##_x86_64_v2
#elif defined(CTX_SIMD_X86_64_V3)
#define CTX_SIMD_SUFFIX(symbol)  symbol##_x86_64_v3
#elif defined(CTX_SIMD_ARM_NEON)
#define CTX_SIMD_SUFFIX(symbol)  symbol##_armv7l_neon
#else

#endif

#endif

#include "ctx.h"
