
/* These are covered in default monospace font, but not in osk:

  ¡¢£¤¥¦§¨ª¬­¯°±²³´µ¶·¸¹º¼½¾¿
«»
   
  Łͻͼͽ;΄΅Ά·ΈΉΊΌΎΏΐΑΒΓΔΕΖΗΘΙΚΛΜΝΞΟ
  ΠΡΣΤΥΦΧΨΩΪΫάέήίΰαβγδεζηθικλμνξοπρςστυφχψωϊϋόύώϐϑϒϓϔϕϖϗϘϙϚϛϜϝϞϟϠϡϢϣϤϥϦϧϨϩϪϫ
  ϬϭϮϯϰϱϲϳϴϵ϶ϷϸϹϺϻϼϽϾЀЁЂЃЄЅІЇЈЉЊЋЌЍЎЏАБВГДЕЖЗИЙКЛМНОПРСТУФХЦЧШЩЪЫЬЭЮЯабвгдеж
  зийклмнопрстуфхцчшщъыьэюяѐёђѓєѕіїјљњћќѝўџѠѡѢѣѤѥѦѧѨѩѪѫѬѭѮѯѰѱѲѳѴѵѶѷѸѹѺѻѼѽѾѿҀ
  ҁ҂ҊҋҌҍҎҏҐґҒғҔҕҖҗҘҙҚқҜҝҞҟҠҡҢңҤҥҦҧҨҩҪҫҬҭҮүҰұҲҳҴҵҶҷҸҹҺһҼҽҾҿӀӁӂӃӄӅӆӇӈӉӊӋӌӍӎӏӐӑ
  ӒӓӔӕӖӗӘәӚӛӜӝӞӟӠӡӢӣӤӥӦӧӨөӪӫӬӭӮӯӰӱӲӳӴӵӶӷӸӹӺӻӼӽӾ
  ←↑→↓−≈▼♠♣♥♦ﬁﬂ  */

#include <unistd.h>
#include <assert.h>
#include <stdlib.h>
#include <stdio.h>
#include <stdint.h>
#include <string.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <sys/ioctl.h>
#include <signal.h>
#include <math.h>
#include <sys/time.h>
#include <time.h>
#include "ctx.h"

int   on_screen_keyboard = 0;
float osk_width = 60.0;
float osk_margin = 6.0;

typedef struct KeyCap {
  char *label;
  char *label_shifted;
  char *label_fn;
  char *label_fn_shifted;
  float wfactor; // 1.0 is regular, tab is 1.5
  char *sequence;
  char *sequence_shifted;
  char *sequence_fn;
  char *sequence_fn_shifted;
  int   sticky;
  int   icon;
  int   down;
  int   hovered;
  int   expanded;
} KeyCap;

int caps_lock = 0;
typedef struct KeyBoard {
  KeyCap keys[9][30];
  int shifted;
  int control;
  int alt;
  int fn;
  int down;

  KeyCap *active_key;
  int expand_timeout;
  int active_alt;
  int releases_in_expanded;
} KeyBoard;


typedef struct _KeyDown {
  uint64_t time;
  KeyCap *key;
  int isdown;
  int device_no;

  int expand_timeout;
} KeyDown;

#define MAX_KEY_DOWN 10

KeyDown key_down[MAX_KEY_DOWN]={{0,},};


//KeyCap *cap = &(kb->keys[row][col]);

static void kb_release_mod (Ctx *ctx, KeyBoard *kb, const char *key)
{

  for (int row = 0; kb->keys[row][0].label; row++)
  {
    for (int col = 0; kb->keys[row][col].label; col++)
    {
      KeyCap *cap = &(kb->keys[row][col]);
      if (!strcmp (cap->label, key))
        cap->down = 0;
    }
  }
  ctx_key_up (ctx, 0, key, 0);
}

static void kb_shift (Ctx *ctx, KeyBoard *kb)
{
  if (kb->shifted)
    return;
  kb->shifted = 1;
  for (int row = 0; kb->keys[row][0].label; row++)
  {
    for (int col = 0; kb->keys[row][col].label; col++)
    {
      KeyCap *cap = &(kb->keys[row][col]);
      if (!strcmp (cap->label, "shift"))
        cap->down = 1;
    }
  }
  ctx_key_down (ctx, 0, "shift", 0);
}


static void kb_unshift (Ctx *ctx, KeyBoard *kb)
{
  if (!kb->shifted)
    return;
  kb->shifted    = 0;
  kb_release_mod (ctx, kb, "shift");
}

static void kb_unalt (Ctx *ctx, KeyBoard *kb)
{
  if (!kb->alt)
    return;
  kb->alt = 0;
  kb_release_mod (ctx, kb, "alt");
}

static void kb_uncontrol (Ctx *ctx, KeyBoard *kb)
{
  if (!kb->control)
    return;
  kb->control = 0;
  kb_release_mod (ctx, kb, "control");
}

void dispatch_key (Ctx *ctx, KeyBoard *kb, KeyCap *key)
{
  if (!key)
    return;
  if (key->sticky)
  {
    key->down = !key->down;

    if (!strcmp (key->sequence, "shift"))
    {
      if (caps_lock)
      {
        caps_lock = 0;
        key->down = 0;
      }
      else
      {
      kb->shifted = key->down;
      if (key->down)
        ctx_key_down (ctx, 0, "shift", 0);
      else
        ctx_key_up (ctx, 0, "shift", 0);
      }
    }
    else if (!strcmp (key->sequence, "control"))
    {
      kb->control = key->down;
      if (key->down)
        ctx_key_down (ctx, 0, "control", 0);
      else
        ctx_key_up (ctx, 0, "control", 0);
    }
    else if (!strcmp (key->sequence, "alt"))
    {
      kb->alt = key->down;
      if (key->down)
        ctx_key_down (ctx, 0, "alt", 0);
      else
        ctx_key_up (ctx, 0, "alt", 0);
    }
    else if (!strcmp (key->sequence, "fn"))
    {
      kb->fn = key->down;
    }
  }
  else
  {
    if (kb->control || kb->alt)
    {
      char combined[200]="";
      if (kb->fn)
        sprintf (&combined[strlen(combined)], "%s", key->sequence_fn);
      else
        sprintf (&combined[strlen(combined)], "%s", key->sequence);

      ctx_key_down (ctx, 0, key->sequence, 0);
      ctx_key_press (ctx, 0, combined, 0);
      ctx_key_up (ctx, 0, key->sequence, 0);
    }
    else
    {
      const char *sequence = key->sequence;

      if (kb->fn && (kb->shifted|caps_lock) && key->sequence_fn_shifted)
      {
        sequence = key->sequence_fn_shifted;
      }
      else if (kb->fn && key->sequence_fn)
      {
        sequence = key->sequence_fn;
      }
      else if ((kb->shifted|caps_lock) && key->sequence_shifted)
      {
        sequence = key->sequence_shifted;
      }
      ctx_key_down (ctx, 0, key->sequence, 0);
      ctx_key_press (ctx, 0, key->sequence, 0);
      if (!strcmp (sequence, "space"))
        sequence = " ";
      if (strcmp (sequence,"return") &&
          strcmp (sequence,"left") &&
          strcmp (sequence,"right") &&
          strcmp (sequence,"up") &&
          strcmp (sequence,"down") &&
          strcmp (sequence,"tab") &&
          strcmp (sequence,"backspace") &&
          strcmp (sequence,"page-up") &&
          strcmp (sequence,"page-downn") &&
          strcmp (sequence,"escape")
          )
        ctx_text_input (ctx, sequence, 0);
      ctx_key_up (ctx, 0, key->sequence, 0);
    }

    kb_unshift (ctx, kb);
    kb_uncontrol (ctx, kb);
    kb_unalt (ctx, kb);
  }
}


static int key_expand (Ctx *ctx, void *a)
{
   KeyBoard *kb = a;
   KeyCap *key = kb->active_key;
   if (key)
   {
     key->expanded = 1;
     key->down = 0;
     key->hovered = 0;

     if (!strcmp (key->label, "shift"))
       caps_lock = !caps_lock;
   }
   for (int i = 0; i < MAX_KEY_DOWN; i++)
   {
     if (key_down[i].isdown)
       key_down[i].isdown = 0;
   }


   kb->active_alt = -1;
   kb->releases_in_expanded = 0;
   ctx_queue_draw (ctx);
   return 0;
}

typedef struct Alternates
{
  char *base;
  char *alternates[8];
} Alternates;

Alternates en_intl_alternates[]=
{
  {"a", {"å", "ä", "æ", "à","á","â","ã", 0}},


  {"i", {"ì","í","î","ï",0}},
  {"I", {"Ì","Í","Î","Ï",0}},
  {"e", {"è","é","ê","ë","€",0}},
  {"o", {"ö", "ø", "ò","ó","ô","õ",0}},
  {"A", {"Å", "Ä", "Æ", "À","Á","Â","Ã",0}},
  {"n", {"ñ", 0 }},
  {"N", {"Ñ", 0}},
  {"d", {"ð","Ð", 0}},
  {"D", {"ð","Ð", 0}},
  {"C", {"Ç", 0}},
  {"c", {"ç", "©", 0}},

  {"'", {"`", "\"", "“","”", 0}},

  {",", {"<", "•",0}},

  {".", {">",":","…",0}},

  {";", {":",0}},
  {"[", {"(","{","<",0}},
  {"]", {")","}",">",0}},
  {"u", {"ù","ú","û","ü",0}},
  {"U", {"Ù","Ú","Û","Ü",0}},
  {"s", {"ß", 0}},
  {"r", {"®", 0}},
  {"Y", {"Ý", "Þ", 0}},
  {"y", {"ý", "þ", "ÿ", 0}},
  {"t", {"™",0}},
  {"/", {"?",0}},
  {"\\", {"|",0}},
  {"E", {"È","É","Ê","Ë","€",0}},
  {"O", {"Ö", "Ø", "Ò","Ó","Ô","Õ", 0}},
  {0, {0}},
};

static void kb_clear_expanded (KeyBoard *kb)
{
  for (int row = 0; kb->keys[row][0].label; row++)
  {
    for (int col = 0; kb->keys[row][col].label; col++)
    {
      KeyCap *cap = &(kb->keys[row][col]);
      cap->expanded = 0;
    }
  }
}


static void alternate_offset (int i, float *xd, float *yd, float c)
{
switch (i)
{
  case 0: *xd = 0;  *yd = -c; break;
  case 1: *xd = c;  *yd = -c; break;
  case 2: *xd = -c; *yd = -c; break;
  case 3: *xd = c;  *yd = 0; break;
  case 4: *xd = -c; *yd = 0; break;
  case 5: *xd = c;  *yd = c; break;
  case 6: *xd = -c; *yd = c; break;
  case 7: *xd = 0;  *yd = c; break;
}
}


static void ctx_on_screen_key_event_expanded (CtxEvent *event, void *a, void *b)
{

  Ctx *ctx = event->ctx;
  KeyCap *key = a;
  KeyBoard *kb = b;
  float h = ctx_virtual_height (ctx);
  float w = ctx_virtual_width (ctx);
  int rows = 0;
  for (int row = 0; kb->keys[row][0].label; row++)
    rows = row+1;

  float c = w / (14.5 + osk_margin * 2); // keycell
  float y0 = h - c * rows;

  if ((event->y < y0) & (event->type == CTX_MOTION))
    return;

  int has_expanded;
  float x = 0;
  float y = 0;

  for (int row = 0; kb->keys[row][0].label; row++)
  {
    x = c * osk_margin;
    y = row * c + y0;
    for (int col = 0; kb->keys[row][col].label; col++)
    {
      KeyCap *cap = &(kb->keys[row][col]);
      has_expanded += cap->expanded;
      key = cap;
      if (has_expanded)
        goto foo;
      x += cap->wfactor * c;
    }
  }
  if (!has_expanded)
    return;
foo:

  int pos = 0;
  int altno = -1;
  for (pos = 0; en_intl_alternates[pos].base; pos++)
    if (!strcmp (en_intl_alternates[pos].base, (kb->shifted|caps_lock)?key->label_shifted:key->label))
      altno = pos;

  int n_alternates = 0;
  if (altno >= 0)
  {
    for(pos = 0; en_intl_alternates[altno].alternates[pos]; pos++)
      n_alternates++;
  }

  const char *best_alternate = en_intl_alternates[altno].base;
  float best_dist = hypotf (event->x - (x + 0 + c * 0.5),
                            event->y - (y + 0 + c * 0.5));

  kb->active_alt = -1;

  if (best_dist < c * 1.8)
  {
    for (int i = 0; i < n_alternates; i++)
    {
      float xd = 0;
      float yd = 0;
      alternate_offset (i, &xd, &yd, c);
      float dist = hypotf (event->x - (x + xd + c * 0.5),
                           event->y - (y + yd + c * 0.5));
      if (dist < best_dist)
      {
         best_dist = dist;
         best_alternate = en_intl_alternates[altno].alternates[i];
         kb->active_alt = i;
      }
    }
  }
  else
  {
    best_alternate = NULL;
  }

  ctx_event_stop_propagate (event);
  switch (event->type)
  {
    case CTX_DRAG_RELEASE:
      if (best_alternate == NULL)
      {
        if (event->y > ctx_height (event->ctx) - c)
        {
          // crude appeoximation of shift location
          if (kb->shifted)
            kb_unshift (ctx, kb);
          else
            kb_shift (ctx, kb);
        }
        else
        {
          kb_clear_expanded (kb);
        }
      }
      else if (kb->releases_in_expanded>=1 ||
               best_alternate != en_intl_alternates[altno].base)
      {
        kb_clear_expanded (kb);
        kb_unshift (ctx, kb);
        ctx_key_down (ctx, 0, key->sequence, 0);
        ctx_key_press (ctx, 0, key->sequence, 0);
        ctx_text_input (ctx, best_alternate, 0);
        ctx_key_up (ctx, 0, key->sequence, 0);
      }
      kb->releases_in_expanded++;
      ctx_queue_draw (event->ctx);
      break;
    case CTX_DRAG_PRESS:
      break;
    case CTX_DRAG_MOTION:
    case CTX_MOTION:
      ctx_queue_draw (event->ctx);
      break;
    default:
      break;
  }
}


static void ctx_on_screen_key_event (CtxEvent *event, void *a, void *b)
{
  Ctx *ctx = event->ctx;
  KeyCap *key = a;
  KeyBoard *kb = b;
  float h = ctx_virtual_height (ctx);
  float w = ctx_virtual_width (ctx);
  int rows = 0;
  for (int row = 0; kb->keys[row][0].label; row++)
    rows = row+1;

  float c = w / (14.5 + osk_margin * 2); // keycell
  float y0 = h - c * rows;

  if ((event->y < y0) & (event->type == CTX_MOTION))
    return;

  key = NULL;

  ctx_event_stop_propagate(event);

  int has_expanded = 0;
  for (int row = 0; kb->keys[row][0].label; row++)
  {
    //float x = c * osk_margin;
    for (int col = 0; kb->keys[row][col].label; col++)
    {
      KeyCap *cap = &(kb->keys[row][col]);
      has_expanded += cap->expanded;
    }
  }

  if (has_expanded)
  {
    ctx_on_screen_key_event_expanded (event, a, b);
    return;
  }

  for (int row = 0; kb->keys[row][0].label; row++)
  {
    float x = c * osk_margin;
    for (int col = 0; kb->keys[row][col].label; col++)
    {
      KeyCap *cap = &(kb->keys[row][col]);
      float y = row * c + y0;
      if (event->x >= x &&
          event->x < x + c * cap->wfactor-0.1 &&
          event->y >= y &&
          event->y < y + c * 0.9)
       {
         key = cap;
         if (cap->hovered == 0)
         {
           ctx_queue_draw (ctx);
         }
         cap->hovered = 1;
       }
      else
       {
         cap->hovered = 0;
       }

      x += cap->wfactor * c;
    }
  }

  event->stop_propagate = 1;

#if 0
  if (has_expanded)
  {
    switch (event->type)
    {
      default:
        break;
      case CTX_DRAG_PRESS:
        kb_clear_expanded (kb);
        ctx_queue_Draw (ctx);
        break;
    }
  }
  else
#endif
  switch (event->type)
  {
     default:
       break;
     case CTX_MOTION:
         ctx_queue_draw (ctx);
       break;
     case CTX_DRAG_MOTION:
        // update key which is down for device.. ?
       if (!key)
         ctx_queue_draw (ctx);
       else
       {
         int i;
         for (i = 0; i < MAX_KEY_DOWN; i++)
         {
           if (key_down[i].device_no == event->device_no)
             break;
         }
         if (i < MAX_KEY_DOWN)
         {
           key_down[i].key = key;
         }

         if (kb->active_key != key)
         {
           if (kb->expand_timeout)
           {
             ctx_remove_idle (ctx, kb->expand_timeout);
             kb->expand_timeout = 0;
             kb->active_key = NULL;
           }
           if (key)
           {
             kb->active_key = key;
             kb->expand_timeout = ctx_add_timeout (ctx, 500, key_expand, kb);
           }
         }
       }
       break;
     case CTX_DRAG_PRESS:
       kb->down = 1;
       {
         ctx_queue_draw (ctx);
         int i = 0;
         for (i = 0; i < MAX_KEY_DOWN; i++)
         {
           if (key_down[i].device_no == event->device_no)
             break;
         }
         if (i == MAX_KEY_DOWN)
         for (i = 0; i < MAX_KEY_DOWN; i++)
         {
           if (key_down[i].isdown == 0)
             break;
         }
         key_down[i].key = key;
         key_down[i].isdown = 1;
         key_down[i].device_no = event->device_no;
         for (i = 0; i < MAX_KEY_DOWN; i++)
         {
           if (key_down[i].isdown && key_down[i].device_no != event->device_no)
           {
             if (!has_expanded)
               dispatch_key (ctx, kb, key_down[i].key);
             key_down[i].isdown = 0;
           }
         }


       if (kb->expand_timeout)
       {
         ctx_remove_idle (ctx, kb->expand_timeout);
         kb->expand_timeout = 0;
       }
         kb->active_key = key;
         kb->expand_timeout = ctx_add_timeout (ctx, 1000, key_expand, kb);
       }
       return;
     case CTX_DRAG_RELEASE:

       kb->down = 0;
       if (kb->expand_timeout)
       {
         ctx_remove_idle (ctx, kb->expand_timeout);
         kb->expand_timeout = 0;
         kb->active_key = NULL;
       }
       ctx_queue_draw (ctx);
       if (!key)
         return;
       if (!on_screen_keyboard)
         return;

       {
         int i = 0;
         for (i = 0; i < MAX_KEY_DOWN; i++)
         {
           if (key_down[i].device_no == event->device_no)
             break;
         }
         if (i < MAX_KEY_DOWN && key_down[i].isdown)
         {
           key_down[i].isdown = 0;
           if (!has_expanded)
             dispatch_key (ctx, kb, key);
         }
       }

      break;
  }
}

KeyBoard en_intl = {
   {  
     { {"esc","esc","`","~",1.0f,"escape","escape","`","~",0},
       {"1","!","F1","F1",1.0f,"1","!","F1","F1",0},
       {"2","@","F2","F2",1.0f,"2","@","F2","F2",0},
       {"3","#","F3","F3",1.0f,"3","#","F3","F3",0},
       {"4","$","F4","F4",1.0f,"4","$","F4","F4",0},
       {"5","%","F5","F5",1.0f,"5","%","F5","F5",0},
       {"6","^","F6","F6",1.0f,"6","^","F6","F6",0},
       {"7","&","F7","F7",1.0f,"7","&","F7","F7",0},
       {"8","*","F8","F8",1.0f,"8","*","F8","F8",0},
       {"9","(","F9","F9",1.0f,"9","(","F9","F9",0},
       {"0",")","F10","F10",1.0f,"0",")","F10","F10",0},
       {"-","_","F11","F11",1.0f,"-","_","F11","F11",0},
       {"=","+","F12","F12",1.0f,"=","+","F12","F12",0},
       {"bs","bs", NULL,NULL,1.2f,"backspace","backspace",NULL,NULL,0,1},
       {NULL}},
     //⌨
     { {"tab","tab",NULL,NULL,1.3f,"tab","tab",NULL,NULL,0,1},
       {"q","Q",NULL,NULL,1.0f,"q","Q",NULL,NULL,0},
       {"w","W",NULL,NULL,1.0f,"w","W",NULL,NULL,0},
       {"e","E",NULL,NULL,  1.0f,"e","E",NULL,NULL,0},
       {"r","R",NULL,NULL,1.0f,"r","R",NULL,NULL,0},
       {"t","T",NULL,NULL,1.0f,"t","T",NULL,NULL,0},
       {"y","Y",NULL,NULL,1.0f,"y","Y",NULL,NULL,0},
       {"u","U",NULL,NULL,1.0f,"u","U",NULL,NULL,0},
       {"i","I",NULL,NULL,1.0f,"i","I",NULL,NULL,0},
       {"o","O",NULL,NULL,  1.0f,"o","O",NULL,NULL,0},
       {"p","P",NULL,NULL,1.0f,"p","P",NULL,NULL,0},
       {"[","{",NULL,NULL,1.0f,"[","{",NULL,NULL,0},
       {"]","}",NULL,NULL,1.0f,"]","}",NULL,NULL,0},
       {"\\","|",NULL,NULL,1.0f,"\\","|",NULL,NULL,0},
       {NULL} },
     { {"fn","fn",NULL,NULL,1.5f,"fn","fn",NULL,NULL,1},
       {"a","A",NULL,NULL, 1.0f,"a","A",NULL,NULL,0},
       {"s","S",NULL,NULL,1.0f,"s","S",NULL,NULL,0},
       {"d","D",NULL,NULL,1.0f,"d","D",NULL,NULL,0},
       {"f","F",NULL,NULL,1.0f,"f","F",NULL,NULL,0},
       {"g","G",NULL,NULL,1.0f,"g","G",NULL,NULL,0},
       {"h","H",NULL,NULL,1.0f,"h","H",NULL,NULL,0},
       {"j","J",NULL,NULL,1.0f,"j","J",NULL,NULL,0},
       {"k","K",NULL,NULL,1.0f,"k","K",NULL,NULL,0},
       {"l","L",NULL,NULL,1.0f,"l","L",NULL,NULL,0},
       {";",":",NULL,NULL,1.0f,";",":",NULL,NULL,0},
       {"'","\"",NULL,NULL,1.0f,"'","\"",NULL,NULL,0},
       {"ret","ret",NULL,NULL,1.5f,"return","return",NULL,NULL,0,1},
       {NULL} },
     { {"control","control",NULL,NULL,1.7f,"control","control",NULL,NULL,1},
       {"z","Z",NULL,NULL,1.0f,"z","Z",NULL,NULL,0},
       {"x","X",NULL,NULL,1.0f,"x","X",NULL,NULL,0},
       {"c","C",NULL,NULL,1.0f,"c","C",NULL,NULL,0},
       {"v","V",NULL,NULL,1.0f,"v","V",NULL,NULL,0},
       {"b","B",NULL,NULL,1.0f,"b","B",NULL,NULL,0},
       {"n","N",NULL,NULL,1.0f,"n","N",NULL,NULL,0},
       {"m","M",NULL,NULL,1.0f,"m","M",NULL,NULL,0},
       {",","<",NULL,NULL,1.0f,",","<",NULL,NULL,0},
       {".",">",NULL,NULL,1.0f,".",">",NULL,NULL,0},
       {"/","?",NULL,NULL,1.1f,"/","?",NULL,NULL,0},
       {"↑","↑","PgUp","PgUp",1.0f,"up","up","page-up","page-up",0,1},
       {NULL} },
     { {"shift","Shift",NULL,NULL,1.3f,"shift","shift",NULL,NULL,1,1},
       {"alt","alt",NULL,NULL,1.3f,"alt","alt",NULL,NULL,1},
       {" "," ",NULL,NULL,8.2f,"space","space",NULL,NULL,0},
       {"←","←","Home","Home",1.0f,"left","left","home","home",0,1},
       {"↓","↓","PgDn","PgDn",1.0f,"down","down","page-down","page-down",0,1},
       {"→","→","End","End",1.0f,"right","right","end","end",0,1},
       {NULL} },
     { {NULL}},
   }
};



  // 0.0 = full tilt
  // 0.5 = balanced
  // 1.0 = full saving
  //
float osk_fade = 0.5f;

float ctx_osk_height (Ctx *ctx)
{
  KeyBoard *kb = &en_intl;

  float w = ctx_virtual_width (ctx);
  int rows = 0;
  for (int row = 0; kb->keys[row][0].label; row++)
    rows = row+1;

  osk_margin =  ((100.0-osk_width) / 100.0) * 15;

  float c = w / (14.5 + osk_margin * 2); // keycell
  return c * rows;
}


void ctx_osk_draw (Ctx *ctx)
{
  if (!on_screen_keyboard)
    return;
  KeyBoard *kb = &en_intl;

  float h = ctx_virtual_height (ctx);
  float w = ctx_virtual_width (ctx);
  float m = h;
  int rows = 0;
  for (int row = 0; kb->keys[row][0].label; row++)
    rows = row+1;

  osk_margin =  ((100.0-osk_width) / 100.0) * 15;


  float c = w / (14.5 + osk_margin * 2); // keycell
  float y0 = h - c * rows;
  if (w < h)
    m = w;
      
  ctx_save (ctx);
  ctx_rectangle (ctx, osk_margin * c, y0, w - osk_margin * 2 * c, c * rows);


  int has_expanded = 0;
  for (int row = 0; kb->keys[row][0].label; row++)
  {
    for (int col = 0; kb->keys[row][col].label; col++)
    {
      KeyCap *cap = &(kb->keys[row][col]);
      has_expanded += cap->expanded;
    }
  }
  if (has_expanded)
    ctx_listen (ctx, CTX_DRAG|CTX_MOTION, ctx_on_screen_key_event_expanded, NULL, &en_intl);
  else
    ctx_listen (ctx, CTX_DRAG, ctx_on_screen_key_event, NULL, &en_intl);


#if 1
  STYLE_WIDGET_BASE;
#else
  XXX : rendering issue with partial updates of gradient, reproducer: terminal cursor moving under gradient of osk
  ctx_linear_gradient (ctx, 0, y0, 0, ctx_virtual_height (ctx));

  float min_a = osk_fade-0.5;
  if (min_a <0) min_a = 0;
  if (min_a > 1) min_a = 1;
  float max_a = osk_fade;
  ctx_gradient_add_stop (ctx, 0.0, 0.0, 0.0, 0.0, min_a);
  ctx_gradient_add_stop (ctx, 1.0, 0.0, 0.0, 0.0, max_a);
#endif

  ctx_preserve (ctx);

  ctx_fill (ctx);

  ctx_text_align (ctx, CTX_TEXT_ALIGN_CENTER);
  ctx_line_width (ctx, m * 0.01);

  float font_size = c * 0.7;
  ctx_font_size (ctx, font_size);

  int had_expanded = 0;

  for (int row = 0; kb->keys[row][0].label; row++)
  {
    float x = c * osk_margin;
    for (int col = 0; kb->keys[row][col].label; col++)
    {
      KeyCap *cap = &(kb->keys[row][col]);
      had_expanded += cap->expanded;
      float y = row * c + y0;
  
      const char *label = cap->label;
      const char *sequence = cap->sequence;

      if ((kb->fn && (kb->shifted|caps_lock) && cap->label_fn_shifted))
      {
        label = cap->label_fn_shifted;
      }
      else if (kb->fn && cap->label_fn)
      {
        label = cap->label_fn;
      }
      else if ((kb->shifted|caps_lock) && cap->label_shifted)
      {
        label= cap->label_shifted;
      }
      if (!strcmp (cap->label, "shift"))
      {
        if (caps_lock)
        {
          label = "SHIFT";
          cap->down = 1;
        }

      }

      if ((kb->fn && (kb->shifted|caps_lock) && cap->sequence_fn_shifted))
      {
        sequence = cap->sequence_fn_shifted;
      }
      else if (kb->fn && cap->sequence_fn)
      {
        sequence = cap->sequence_fn;
      }
      else if ((kb->shifted|caps_lock) && cap->sequence_shifted)
      {
        sequence= cap->sequence_shifted;
      }

      if (ctx_utf8_strlen (label) > 1)
      {
        if (font_size != c * 0.33)
        {
          font_size = c * 0.33;
          ctx_font_size (ctx, font_size);
        }
      }
      else
      {
        if (font_size != c * 0.7)
        {
          font_size = c * 0.7;
          ctx_font_size (ctx, font_size);
        }
      }

      ctx_reset_path (ctx);
      
      if (cap->down || (cap->hovered && kb->down))
      {
        ctx_round_rectangle (ctx, x, y,
                                c * (cap->wfactor-0.1),
                                c * 0.9,
                                c * 0.1);
        STYLE_TEXT;
        ctx_fill (ctx);
      }

      ctx_text_align (ctx, CTX_TEXT_ALIGN_CENTER);
      ctx_text_baseline (ctx, CTX_TEXT_BASELINE_MIDDLE);

      ctx_move_to (ctx, x + cap->wfactor * c*0.5, y + c * 0.5);

      if (cap->down || (cap->hovered && kb->down))
      {
        STYLE_WIDGET_BASE;
      }
      else
      {
        STYLE_TEXT;
      }

      if (cap->icon)
      {
        if (get_icon (sequence))
        icon (ctx, x + cap->wfactor * c * 0.5 - 0.5*c, y + c * 0.5 - 0.5*c, c, c,  cap->sequence);
        else
        ctx_text (ctx, label);
      }
      else
      {
        ctx_text (ctx, label);
      }

      x += cap->wfactor * c;
    }
  }
  if (had_expanded)
  {

    for (int row = 0; kb->keys[row][0].label; row++)
    {
      float x = c * osk_margin;
      for (int col = 0; kb->keys[row][col].label; col++)
      {
        KeyCap *cap = &(kb->keys[row][col]);
        float y = row * c + y0;
    
        //const char *label = cap->label;
        if (cap->expanded)
        {
           int pos = 0;
           int altno = -1;
           for (pos = 0; en_intl_alternates[pos].base; pos++)
             if (!strcmp (en_intl_alternates[pos].base, (kb->shifted|caps_lock)?cap->label_shifted:cap->label))
                 altno = pos;

           if (altno >= 0)
           {
             int n_alternates = 0;
             for(pos = 0; en_intl_alternates[altno].alternates[pos]; pos++)
               n_alternates++;

             ctx_rectangle (ctx, x - c, y - c, c * 3, c *3);
             STYLE_WIDGET_BASE;
             ctx_fill (ctx);
             ctx_rectangle (ctx, x - c, y - c, c * 3, c *3);
             STYLE_WIDGET_BORDER;
             ctx_line_width (ctx, em * 0.1);
             ctx_stroke (ctx);


             for (int i = 0; i < n_alternates; i++)
             {
               float xd = 0;
               float yd = 0;
               alternate_offset (i, &xd, &yd, c);
               if (i == kb->active_alt)
               {
                 ctx_rectangle (ctx, x + xd, y + yd, c, c);
                 STYLE_TEXT;
                 ctx_fill (ctx);
                 STYLE_WIDGET_BASE_FOCUSED;
                 yd -= 1;
               }
               else
                 STYLE_TEXT;
               ctx_move_to (ctx, x + xd + c * 0.5, y + yd + c * 0.5);
               ctx_text (ctx, en_intl_alternates[altno].alternates[i]);

             }
             {
               STYLE_TEXT;
               ctx_move_to (ctx, x + c * 0.5, y + c * 0.5);
               ctx_text (ctx, en_intl_alternates[altno].base);
             }


           }
           else
           {
             cap->expanded = 0;
           }
           
        }
  
        x += cap->wfactor * c;
      }
    }

  }

  ctx_restore (ctx);
}
