// an event tester
//
//

#include "ctx.h"

typedef struct MtInfo {
  int id;
  float x;
  float y;
  int down;
} MtInfo;

int modifiers = 0;

MtInfo fingers[10]={};

CtxList *textlog = NULL;

static void free_it (void *data, void *user_data)
{
  ctx_free (data);
}

void log_add (const char *buf)
{
  char *copy = ctx_strdup (buf);
  ctx_list_append_full (&textlog, copy, free_it, NULL);

  while (ctx_list_length (textlog) > 30)
  {
    ctx_list_remove (&textlog, textlog->data);
  }

}



static void action_quit(CtxEvent *event, void *data1, void *data2) {
  ctx_exit(event->ctx);
  while (textlog)
  {
    ctx_list_remove (&textlog, textlog->data);
  }

  ctx_queue_draw(event->ctx);
} 

static int device_id_to_finger(int device_id)
{
  for (int i =1; i<10;i++)
  {
    if (fingers[i].id == device_id) return i;
  }
  for (int i =1; i<10;i++)
  {
    if (fingers[i].id == 0){
      fingers[i].id = device_id;
      return i;
    }
  }
  return 0;
}

static void misc_event (CtxEvent *event, void *a, void *b)
{
  modifiers = event->state;
  ctx_queue_draw (event->ctx);
  char msg[64]="";

  switch (event->type)
  {
    case CTX_MESSAGE:
      sprintf (msg, "message [%s]\n", event->string);
      break;
    case CTX_SCROLL:
     sprintf (msg, "scroll [%i] x:%f y:%f device-no:%i\n", event->scroll_direction, event->x, event->y, event->device_no);
      break;
    case CTX_TEXT_INPUT:
     sprintf (msg, "text_input [%s]\n", event->string);
	  break;
    case CTX_KEY_DOWN:
     sprintf (msg, "keydown [%s] scan:%u device-no:%i\n", event->string, event->scan, event->device_no);
	  break;
    case CTX_KEY_UP:
     sprintf (msg, "keyup [%s] scan:%u device-no:%i\n", event->string, event->scan, event->device_no);
	  break;
    case CTX_KEY_PRESS:
	  if (!strcmp (event->string, "escape"))
	  {
	    action_quit (event, a, b);
	    return;
	  }
     sprintf (msg, "keypress [%s] device-no:%i\n", event->string, event->device_no);
	  break;
    default:
	  break;
  }

  if (msg[0])
    log_add (msg);
  ctx_queue_draw (event->ctx);
}

static void drag_event (CtxEvent *event, void *a, void *b)
{
  int finger_no = device_id_to_finger (event->device_no);
  modifiers = event->state;
  char msg[64]="";


  switch (event->type)
  {
    case CTX_DRAG_PRESS:
     fingers[finger_no].x = event->x;
     fingers[finger_no].y = event->y;
     fingers[finger_no].down = 1;
     sprintf (msg, "drag-press %f,%f device-no:%i finger-no:%i\n", event->x, event->y, event->device_no, finger_no);
     break;
    case CTX_DRAG_RELEASE:
     fingers[finger_no].x = event->x;
     fingers[finger_no].y = event->y;
     fingers[finger_no].down = 0;
     sprintf (msg, "drag-release %f,%f device-no:%i finger-no:%i\n", event->x, event->y, event->device_no, finger_no);
     break;
    case CTX_DRAG_MOTION:
     fingers[finger_no].x = event->x;
     fingers[finger_no].y = event->y;
     sprintf (msg, "drag-motion %f,%f device-no:%i finger-no:%i\n", event->x, event->y, event->device_no, finger_no);
     break;
    default: break;
  }
  if (msg[0])
    log_add (msg);
  ctx_queue_draw (event->ctx);
}


static void et_loop_iteration(Ctx *ctx, float delta_s, void *data)
{
  float width = ctx_width (ctx);
  float height = ctx_height (ctx);

  static float col = 0.5f;

  ctx_rgb (ctx, 0,col,0);
  ctx_paint (ctx);
  //col+=0.02;
  //if (col>1.0)col=0.0;

  ctx_font_size (ctx, height * 0.1);
  ctx_rgba (ctx, 1, 1, 1, 1);
  ctx_move_to (ctx, 0, height * 0.3);
  if (modifiers & CTX_MODIFIER_STATE_SHIFT)
    ctx_text (ctx, "shift");
  ctx_move_to (ctx, 0, height * 0.4);
  if (modifiers & CTX_MODIFIER_STATE_ALT)
    ctx_text (ctx, "alt");
  ctx_move_to (ctx, 0, height * 0.5);
  if (modifiers & CTX_MODIFIER_STATE_CONTROL)
    ctx_text (ctx, "control");

  ctx_font_size (ctx, height * 0.03);
  float y = height * 0.05;
  for (CtxList *l = textlog; l; l = l->next)
  {
    char *line = (char*)l->data;
    ctx_move_to (ctx, height * 0.10, y);
    ctx_text (ctx, line);
    y += height * 0.03;
  }


  for (int i = 0; i < 10; i++)
  {
    float x = fingers[i].x;
    float y = fingers[i].y;
    ctx_rectangle (ctx, x-25, y-25, 50, 50);
    if (fingers[i].down)
    {
      ctx_rgba (ctx,1,1,0,1);
    }
    else
    {
      ctx_rgba (ctx,1,1,1,0.5);
    }
    ctx_fill (ctx);
  }

  ctx_rectangle (ctx, 0, 0, width, height);
  ctx_listen (ctx, CTX_DRAG, drag_event, NULL, NULL);
  ctx_listen (ctx, CTX_SCROLL, misc_event, NULL, NULL);
  ctx_reset_path (ctx);
  ctx_listen (ctx, CTX_MESSAGE, misc_event, NULL, NULL);
  // no path lets us register for keys for the window
  ctx_listen (ctx, CTX_TEXT_INPUT, misc_event, NULL, NULL);
  ctx_listen (ctx, CTX_KEY_DOWN|CTX_KEY_UP|CTX_KEY_PRESS, 
              misc_event, NULL, NULL);

  ctx_add_key_binding(ctx, "escape", NULL, "foo", action_quit, NULL);
}

#if ESP_PLATFORM
void app_main(void)
#else
int main(int argc, char **argv) 
#endif
{
  for (int i = 0; i < 10; i++)
  {
    fingers[i].x = -100;
    fingers[i].y = -100;
  }
  ctx_main (NULL, et_loop_iteration, NULL);
#ifndef ESP_PLATFORM
  return 0;
#endif
}
