#if CTX_STB_IMAGE

#ifndef _DEFAULT_SOURCE
#define _DEFAULT_SOURCE
#endif

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <math.h>
#include "ctx.h"

//#define STBI_NO_STDIO
#include "stb_image.h"


static int stb_w = -1;
static int stb_h = -1;

static int image_smoothing = 1;

static float ox0 = 0;
static float oy0 = 0;
static float img_scale = 1.0;
static float angle = 0.0;
static int img_dirty = 1;

static int auto_size = 1;

static int rotating = 0;
static int repeat = 0;

/****************************/
CtxList *images = NULL;
static const char *path = NULL;

static uint8_t *stb_pixels = NULL;
static int stb_components = 0;

static void image_drag (CtxEvent *event, void *data0, void *data1)
{
   ox0 += event->delta_x / img_scale;
   oy0 += event->delta_y / img_scale;
   img_dirty++;
   auto_size = 0;
}

static void image_scroll (CtxEvent *event, void *data0, void *data1)
{
   Ctx *ctx = event->ctx;
   ox0 -=  (ctx_width (ctx) / 2) / img_scale;
   oy0 -=  (ctx_height (ctx) / 2) / img_scale;

   if (event->scroll_direction == CTX_SCROLL_DIRECTION_UP)
      img_scale *= 1.1;
   else
      img_scale /= 1.1;
   ox0 +=  (ctx_width (ctx) / 2) / img_scale;
   oy0 +=  (ctx_height (ctx) / 2) / img_scale;
   auto_size = 0;
   img_dirty=1;ctx_queue_draw (ctx);
#if 0
   ox0 += event->delta_x / img_scale;
   oy0 += event->delta_y / img_scale;
   img_scale *= 1.1;
   img_dirty++;
#endif
   //auto_sisze = 0;
}

static int imgquit = 0;
static const char *next_path = NULL;

const char *image_list_next_path (CtxList *list, const char *path)
{
  if (!list)
    return NULL;
  for (CtxList *l = list; l; l = l->next)
  {
    char *ipath = l->data;
    if (!strcmp (ipath, path))
    {
      if (l->next)
      {
	 return (char*)l->next->data;
      }
      else
	 return (char*)list->data;
    }
  }
  return (char*)list->data;
}

int last_was_prev = 0;

void image_next ()
{
  imgquit = 1;
  if (!images)
    return;
  next_path = image_list_next_path (images, path);
  last_was_prev = 0;
}

const char *image_list_prev_path (CtxList *list, const char *path)
{
  if (!images)
    return NULL;
  char *prev = NULL;
  for (CtxList *l = images; l; l = l->next)
  {
    char *ipath = l->data;
    if (!strcmp (ipath, path))
    {
      if (prev)
      {
	 return prev;
      }
      else
      {
	l = images;
	while (l->next) l = l->next;
	return (char*)l->data;
      }
    }
    prev = ipath;
  }
  return (char*)images->data;
}


void image_prev ()
{
  imgquit = 1;
  last_was_prev = 1;
  if (!images)
    return;
  next_path = image_list_prev_path (images, path);
}


void ctx_handle_img (Ctx *ctx, const char *path)
{
  if (!path) return;

  if (path) stb_pixels = stbi_load (path, &stb_w, &stb_h, &stb_components, 4);

  if (!stb_pixels) 
  {
    if (last_was_prev)
    image_prev ();
    else
    image_next ();
    return;
  }

  auto_size = 1;
  img_scale  = ctx_width (ctx) * 1.0 / stb_w;
  float scaleh = ctx_height (ctx) * 1.0 / stb_h;

  if (scaleh < img_scale)
     img_scale = scaleh;

  int loaded = 0;
  char eid[PATH_MAX]="";
  strcpy (eid, path);

  // center
  ox0 = (ctx_width(ctx)/img_scale-(stb_w)) / 2;
  oy0 = (ctx_height(ctx)/img_scale-(stb_h)) / 2;


  float cursor_translate = ctx_height (ctx) * 0.25;
  float shift_cursor_translate = 1;//cursor_translate / 8;

  imgquit = 0;
  while (!imgquit)
  {
    CtxEvent *event;
    if (img_dirty)
    {
      if (auto_size)
      {
         img_scale = ctx_width (ctx) * 1.0 / stb_w;
         scaleh = ctx_height (ctx) * 1.0 / stb_h;
         if (scaleh < img_scale)
           img_scale = scaleh;
         ox0 = (ctx_width(ctx)/img_scale-(stb_w)) / 2;
         oy0 = (ctx_height(ctx)/img_scale-(stb_h)) / 2;
      }

      ctx_start_frame (ctx);
      ctx_save (ctx);
      ctx_rectangle (ctx, 0,0, ctx_width(ctx), ctx_height(ctx));
      ctx_listen (ctx, CTX_DRAG_MOTION, image_drag, NULL, NULL);
      ctx_listen (ctx, CTX_SCROLL, image_scroll, NULL, NULL);
      ctx_gray (ctx, 0.0f);
      ctx_fill (ctx);
      //ctx_reset_path (ctx);
      if (image_smoothing == 0)
        ctx_image_smoothing (ctx, 0);
      if (repeat)
        ctx_extend (ctx, CTX_EXTEND_REPEAT);
      ctx_compositing_mode (ctx, CTX_COMPOSITE_COPY);

#if 1
      ctx_rectangle (ctx, 0,0, ctx_width(ctx), ctx_height(ctx));
      ctx_save (ctx);

      if (angle != 0.0f)
      {
          ctx_rotate (ctx, 0.08);
           ctx_apply_transform (ctx, 1, 0, 0.0,
                               0, 1, 0,
                               0.0, 0.001, 1.2);

      }

      ctx_scale (ctx, img_scale, img_scale);
      ctx_translate (ctx, ox0, oy0);



     if (loaded)
       ctx_texture (ctx, eid, 0.0f, 0.0f);
     else
     {
        ctx_define_texture (ctx, eid, stb_w, stb_h, stb_w * 4, CTX_FORMAT_RGBA8,
                            stb_pixels, eid);
	loaded = 1;
     }
      ctx_fill (ctx);
#if 0
      ctx_rectangle (ctx, 0,0, stb_w, stb_h);
      ctx_rgba (ctx, 1,0,0,0.25);
      ctx_stroke (ctx);
      ctx_logo (ctx, stb_w * 0.5, stb_h * 0.5, stb_h * 0.4);
#endif
      ctx_restore (ctx);

#else
      if (!loaded)
      {
        ctx_define_texture (ctx, NULL, stb_w, stb_h, stb_w * 4, CTX_FORMAT_RGBA8,
                            stb_pixels, eid);
	loaded = 1;
      }
      if (eid[0])
      {
        ctx_draw_texture (ctx, eid, ox0 * img_scale, oy0 * img_scale, stb_w * img_scale, stb_h *  img_scale);
        //ctx_rectangle (ctx, ox0 * img_scale, oy0 * img_scale, stb_w * img_scale, stb_h *  img_scale);
        ctx_rgba (ctx, 0.5,1.0,0.0,0.5);
        ctx_fill (ctx);

      }
#endif
      ctx_restore (ctx);
      ctx_end_frame (ctx);
      img_dirty = 0;
      if (rotating)
      {
        angle += 0.001;
        img_dirty = 1;ctx_queue_draw (ctx);
        if (angle > 1.0) angle = 0.0;
      }
    }
   
    while ((event = ctx_get_event (ctx)))
    {
      switch (event->type)
      {
        case CTX_KEY_PRESS:
          if (!strcmp (event->string, "q"))
            imgquit = 1;
	  else if (!strcmp (event->string, "n"))
	  {
	    image_next (); 
	  }
	  else if (!strcmp (event->string, "p"))
	  {
	    image_prev (); 
	  }
          else if (!strcmp (event->string, "i"))
            image_smoothing = !image_smoothing;
          else if (!strcmp (event->string, "down"))
            oy0 -= cursor_translate / img_scale;
          else if (!strcmp (event->string, "up"))
            oy0 += cursor_translate / img_scale;
          else if (!strcmp (event->string, "left"))
            ox0 += cursor_translate / img_scale;
          else if (!strcmp (event->string, "right"))
            ox0 -= cursor_translate / img_scale;
          else if (!strcmp (event->string, "shift-down"))
            oy0 -= shift_cursor_translate / img_scale;
          else if (!strcmp (event->string, "shift-up"))
            oy0 += shift_cursor_translate / img_scale;
          else if (!strcmp (event->string, "shift-left"))
            ox0 += shift_cursor_translate / img_scale;
          else if (!strcmp (event->string, "shift-right"))
            ox0 -= shift_cursor_translate / img_scale;
          else if (!strcmp (event->string, "f"))
          {
            img_scale = ctx_width (ctx) * 1.0 / stb_w;
            scaleh = ctx_height (ctx) * 1.0 / stb_h;
            if (scaleh < img_scale)
              img_scale = scaleh;
            ox0 = (ctx_width(ctx)/img_scale-(stb_w)) / 2;
            oy0 = (ctx_height(ctx)/img_scale-(stb_h)) / 2;
            auto_size = 1;
          }
          else if (!strcmp (event->string, "3"))
          {
            ox0 -=  (ctx_width (ctx) / 2) / img_scale;
            oy0 -=  (ctx_height (ctx) / 2) / img_scale;
            img_scale = 1.0/3;
            ox0 +=  (ctx_width (ctx) / 2) / img_scale;
            oy0 +=  (ctx_height (ctx) / 2) / img_scale;
            auto_size = 0;
          }
          else if (!strcmp (event->string, "1"))
          {
            ox0 -=  (ctx_width (ctx) / 2) / img_scale;
            oy0 -=  (ctx_height (ctx) / 2) / img_scale;
            img_scale = 1.0;
            ox0 +=  (ctx_width (ctx) / 2) / img_scale;
            oy0 +=  (ctx_height (ctx) / 2) / img_scale;
            auto_size = 0;
          }
          else if (!strcmp (event->string, "2"))
          {
            ox0 -=  (ctx_width (ctx) / 2) / img_scale;
            oy0 -=  (ctx_height (ctx) / 2) / img_scale;
            img_scale = 2.0;
            ox0 +=  (ctx_width (ctx) / 2) / img_scale;
            oy0 +=  (ctx_height (ctx) / 2) / img_scale;
            auto_size = 0;
          }
          else if (!strcmp (event->string, "5"))
          {
            ox0 -=  (ctx_width (ctx) / 2) / img_scale;
            oy0 -=  (ctx_height (ctx) / 2) / img_scale;
            img_scale = 0.5;
            ox0 +=  (ctx_width (ctx) / 2) / img_scale;
            oy0 +=  (ctx_height (ctx) / 2) / img_scale;
            auto_size = 0;
          }
          else if (!strcmp (event->string, "+")||
                   !strcmp (event->string, "="))
          {
            ox0 -=  (ctx_width (ctx) / 2) / img_scale;
            oy0 -=  (ctx_height (ctx) / 2) / img_scale;
            img_scale *= 1.1;
            ox0 +=  (ctx_width (ctx) / 2) / img_scale;
            oy0 +=  (ctx_height (ctx) / 2) / img_scale;
            auto_size = 0;
          }
          else if (!strcmp (event->string, "-"))
          {
            ox0 -=  (ctx_width (ctx) / 2) / img_scale;
            oy0 -=  (ctx_height (ctx) / 2) / img_scale;
            img_scale /= 1.1;
            ox0 +=  (ctx_width (ctx) / 2) / img_scale;
            oy0 +=  (ctx_height (ctx) / 2) / img_scale;
            auto_size = 0;
          }
          else if (!strcmp (event->string, "."))
          {
            ox0 -=  (ctx_width (ctx) / 2) / img_scale;
            oy0 -=  (ctx_height (ctx) / 2) / img_scale;
            img_scale *= 1.01;
            ox0 +=  (ctx_width (ctx) / 2) / img_scale;
            oy0 +=  (ctx_height (ctx) / 2) / img_scale;
            auto_size = 0;
          }
          else if (!strcmp (event->string, ","))
          {
            ox0 -=  (ctx_width (ctx) / 2) / img_scale;
            oy0 -=  (ctx_height (ctx) / 2) / img_scale;
            img_scale /= 1.01;
            ox0 +=  (ctx_width (ctx) / 2) / img_scale;
            oy0 +=  (ctx_height (ctx) / 2) / img_scale;
            auto_size = 0;
          }
          else if (!strcmp (event->string, "p"))
          {
            rotating = !rotating;
            ctx_queue_draw (event->ctx);
          }
          else if (!strcmp (event->string, "r"))
          {
            repeat = !repeat;
            ctx_queue_draw (event->ctx);
          }
          img_dirty ++;
          break;
        default:
          break;
      }
    }
  }
  imgquit = 0;
}


#include <sys/stat.h>
#include <sys/types.h>
#include <stdio.h>
#include <libgen.h>

#include <unistd.h>                                
#include <dirent.h>                                        
#include <sys/stat.h>
#include <sys/types.h>                            
#include <sys/wait.h>                             
#include <math.h>                                          
#include <ctype.h>
#include <signal.h>

static int custom_sort (const struct dirent **a,  
                        const struct dirent **b)   
{                              
  if ((*a)->d_type != (*b)->d_type)    {                                          
    return ((*a)->d_type - (*b)->d_type);     }                
  return strcmp ((*a)->d_name , (*b)->d_name);             
}

#if CTX_BIN_BUNDLE
int ctx_img_main(int argc, char *argv[])
#else
int main(int argc, char *argv[])
#endif
{
  Ctx *ctx;
  if (!argv[1]) return -1;

  for (int i = 1; argv[i]; i++)
  {
    if (argv[i][0]!='-')
    {
  path = argv[i];
  if (strchr (path, ':') && (strchr(path,':')-path) < 6)
  {
    path = strchr (path, ':');
    if (path[1] == '/') path++;
    if (path[1] == '/') path++;
  }

      ctx_list_append_full (&images, ctx_strdup (path), (void*)ctx_free, NULL);
    }
  }


  if (ctx_list_length (images) == 1)
  {
    char *bname = dirname (strdup(path));
    struct dirent **namelist = NULL;
    int n;

    n = scandir (bname, &namelist, NULL, custom_sort);

    ctx_list_free (&images);
    for (int i = 0; i < n; i++)
    {
      const char *d_name = namelist[i]->d_name;
      if (d_name[0] != '.')
      {
        char *npath = ctx_malloc (strlen (bname) + strlen (d_name) + 2);
        sprintf (npath, "%s/%s", bname, d_name);

	if (ctx_media_type_class (ctx_path_get_media_type (npath)) == CTX_MEDIA_TYPE_IMAGE)
        ctx_list_append_full (&images, npath, (void*)ctx_free, NULL);
	else
	ctx_free (npath);
      }
    }

  }

  ctx = ctx_new (-1, -1, NULL);

  do {
    ctx_handle_img (ctx, path);

    if (next_path)
    {
      path = next_path;
      next_path = NULL;
    }
    else path = NULL;
  } while (path);

  ctx_list_free (&images);

  ctx_destroy (ctx);
  return 0;
}


#else
#if CTX_BIN_BUNDLE
int ctx_img_main (int argc, char *argv[])
#else
int main (int argc, char *argv[])
#endif
{return -1;}

#endif
